#include "script.h"
static ScriptState _script_state;
static void _add_event(int timestamp, ScriptEventType et, PlayerType who, str value);
ScriptState* global_script_state(void) {
    return & _script_state;
}
int speech_time(str text) {
    int spaces = land_count(text, " ");
    return 30 + spaces * 10 + strlen(text) * 2;
}
static void _add_event(int timestamp, ScriptEventType et, PlayerType who, str value) {
    ScriptState * ss = global_script_state();
    ScriptEvent * e;
    land_alloc(e);
    e->timestamp = timestamp;
    ss->last_tick = e->timestamp;
    if (et == SetSpeech) {
        ss->last_tick += speech_time(value);
    }
    e->et = et;
    e->who = who;
    e->value = value ? land_strdup(value) : NULL;
    if (! ss->events) {
        ss->events = land_list_new();
    }
    land_list_add(ss->events, e);
}
void script_reset(void) {
    ScriptState * ss = global_script_state();
    land_list_clear(ss->events);
}
void add_event_absolute(float seconds, ScriptEventType et, PlayerType who, str value) {
    Game * game = game_global();
    _add_event(game->ticks + 60 * seconds, et, who, value);
}
void add_event(float seconds, ScriptEventType et, PlayerType who, str value) {
    ScriptState * ss = global_script_state();
    _add_event(ss->last_tick + seconds * 60, et, who, value);
}
void script_init_for_level(void) {
    Game * game = game_global();
    Persist * gc = game->current;
    game->cutscene = 0;
    script_reset();
    ScriptState * ss = global_script_state();
    ss->skipped = 0;
    if (land_equals(gc->level_number, "_tom")) {
        script_tom();
    }
    if (land_equals(gc->level_number, "_fox")) {
        script_fox();
    }
}
void script_tick(void) {
    Game * game = game_global();
    ScriptState * ss = global_script_state();
    if (! ss->events) {
        return ;
    }
    ScriptEvent * ne = land_list_get_first(ss->events);
    if (! ne) {
        return ;
    }
    int t = game->ticks + ss->skipped;
    if (t >= ne->timestamp) {
        land_list_pop_first(ss->events);
        if (ss->current) {
            if (ss->current->value) {
                land_free(ss->current->value);
            }
            land_free(ss->current);
        }
        ss->current = ne;
        //print("event %d (who=%d) %s", ne.et, ne.who, ne.value)
        if (ne->et == SetKx) {
            if (ne->who == PlayerWitch) {
                game->input_kx = land_to_int(ne->value);
            }
            else {
                game->input2_kx = land_to_int(ne->value);
            }
        }
        else if (ne->et == SetKy) {
            if (ne->who == PlayerWitch) {
                game->input_ky = land_to_int(ne->value);
            }
            else {
                game->input2_ky = land_to_int(ne->value);
            }
        }
        else if (ne->et == SetSwitch) {
            Player * p = player_find(ne->who);
            if (land_equals(ne->value, "0")) {
                p->variant = 0;
            }
            if (land_equals(ne->value, "1")) {
                p->variant = 1;
            }
            if (land_equals(ne->value, "2")) {
                game->have_switch = 1;
                p->variant = 2;
            }
        }
        else if (ne->et == SetSpeech) {
            Player * p = player_find(ne->who);
            //print("speech %d", ne.who)
            if (p) {
                if (p->text) {
                    land_free(p->text);
                }
                p->text = ne->value;
                p->text_t = game->ticks + speech_time(p->text);
            }
            ne->value = NULL;
        }
        else if (ne->et == SetCutscene) {
            game->cutscene = land_to_int(ne->value);
            game->input_kx = 0;
            game->input_ky = 0;
            game->current->player->variant = 0;
        }
        else if (ne->et == SetVisible) {
            Player * p = player_find(ne->who);
            if (land_equals(ne->value, "0")) {
                player_remove(p);
            }
        }
        else if (ne->et == SetDead) {
            Player * p = player_find(ne->who);
            p->dead = land_to_int(ne->value);
        }
        else if (ne->et == SetMusic) {
            stream_sound(ne->value);
        }
    }
}
void script_skip(void) {
    Game * game = game_global();
    player_cancel_texts();
    ScriptState * ss = global_script_state();
    if (! ss->events) {
        return ;
    }
    if (! ss->current) {
        return ;
    }
    ScriptEvent * ne = land_list_get_first(ss->events);
    if (! ne) {
        return ;
    }
    if (ss->current->et != SetSpeech) {
        return ;
    }
    int t = game->ticks;
    ss->skipped = ne->timestamp - t;
}
void script_off(void) {
    Game * game = game_global();
    game->cutscene = 0;
}
void script_tom(void) {
    float s = 0.1;
    add_event_absolute(0, SetCutscene, PlayerNone, "1");
    add_event(1, SetSpeech, PlayerVillain, "good bye");
    add_event(0.1, SetKx, PlayerVillain, "1");
    add_event(1.3, SetKx, PlayerVillain, "0");
    add_event(0, SetSpeech, PlayerWitch, "Wait!");
    add_event(0.1, SetKx, PlayerWitch, "1");
    add_event(1, SetKx, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerWitch, "Don't leave!");
    add_event(0.1, SetKx, PlayerVillain, "-1");
    add_event(0.1, SetKx, PlayerVillain, "0");
    add_event(1, SetSpeech, PlayerVillain, "You can't stop me.");
    add_event(s, SetSpeech, PlayerWitch, "I thought you liked me.");
    add_event(s, SetSpeech, PlayerVillain, "I despise you like the rest of them.");
    add_event(s, SetSpeech, PlayerWitch, "I don't believe that!");
    add_event(0.1, SetKx, PlayerVillain, "1");
    add_event(0.9, SetKx, PlayerVillain, "0");
    add_event(s, SetSpeech, PlayerVillain, "Go back home!");
    add_event(s, SetSpeech, PlayerWitch, "How can I?");
    add_event(s, SetSpeech, PlayerVillain, "Do what you want then!");
    add_event(s, SetSpeech, PlayerWitch, "You're not supposed to use magic for evil!");
    add_event(s, SetSpeech, PlayerVillain, "Says who?");
    add_event(s, SetSpeech, PlayerWitch, "I'll have to stop you then.");
    add_event(s, SetSpeech, PlayerVillain, "Hahahaha, you're too weak.");
    add_event(s, SetSpeech, PlayerWitch, "Please stay!");
    add_event(s, SetSpeech, PlayerVillain, "Hahahaha! If you try to make me stay, you'll get hurt.");
    add_event(1.5, SetKy, PlayerWitch, "2");
    add_event(0.1, SetKy, PlayerWitch, "0");
    add_event(2.1, SetKy, PlayerVillain, "-1");
    add_event(0.1, SetKy, PlayerVillain, "0");
    add_event(1, SetKx, PlayerVillain, "-1");
    add_event(0.1, SetKx, PlayerVillain, "0");
    add_event(0.5, SetKy, PlayerVillain, "1");
    add_event(0.1, SetKy, PlayerVillain, "0");
    add_event(0.5, SetKx, PlayerVillain, "1");
    add_event(1, SetKx, PlayerVillain, "0");
    add_event(0.1, SetVisible, PlayerVillain, "0");
    add_event(0.1, SetCutscene, PlayerNone, "0");
}
void script_fox(void) {
    float s = 0.1;
    add_event_absolute(0, SetCutscene, PlayerNone, "1");
    add_event(1, SetSpeech, PlayerFox, "Hey!");
    add_event(0, SetKx, PlayerFox, "1");
    add_event(0.5, SetKx, PlayerFox, "0");
    add_event(1, SetKx, PlayerWitch, "-1");
    add_event(1.5, SetKx, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerWitch, "A talking fox!");
    add_event(s, SetSpeech, PlayerFox, "A talking human!");
    add_event(s, SetSpeech, PlayerWitch, "Hey!");
    add_event(s, SetSpeech, PlayerFox, "Beating an evil wizard ten times as strong as yourself - it may be possible.");
    add_event(s, SetSpeech, PlayerWitch, "He's only like 5 times stronger!");
    add_event(s, SetSpeech, PlayerFox, "But doing so with confused feelings? That is impossible.");
    add_event(s, SetSpeech, PlayerWitch, "...");
    add_event(s, SetSpeech, PlayerFox, "There is a way to forget. You have to split your mind.");
    add_event(s, SetSpeech, PlayerWitch, "Split my mind?");
    add_event(s, SetSpeech, PlayerFox, "Yes, but it will divide your powers.");
    add_event(s, SetSpeech, PlayerWitch, "Divide my powers?");
    add_event(s, SetSpeech, PlayerFox, "Yes, and so diverting power will be everything.");
    add_event(s, SetSpeech, PlayerWitch, "Diverting power?");
    add_event(s, SetSpeech, PlayerFox, "Think shield. Think engine. Think cannon.");
    add_event(s, SetSpeech, PlayerWitch, "???");
    add_event(s, SetSpeech, PlayerFox, "Think of shielding yourself and you will be able to protect against harm.");
    add_event(s, SetSpeech, PlayerWitch, "Got it.");
    add_event(s, SetSpeech, PlayerFox, "Think of your strength and you will have it.");
    add_event(1, SetSwitch, PlayerWitch, "2");
    add_event(1, SetKy, PlayerWitch, "-1");
    add_event(0.2, SetKy, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerWitch, "Whoa!");
    add_event(s, SetSpeech, PlayerFox, "And now think of your anger...");
    add_event(1, SetSwitch, PlayerWitch, "1");
    add_event(1, SetKy, PlayerWitch, "-1");
    add_event(0.2, SetKy, PlayerWitch, "0");
    add_event(0.3, SetKx, PlayerFox, "-1");
    add_event(0.3, SetKx, PlayerFox, "1");
    add_event(0.1, SetKx, PlayerFox, "0");
    add_event(0.1, SetSpeech, PlayerFox, "Hey!!!");
    add_event(s, SetSpeech, PlayerWitch, "I'll destroy him!");
    add_event(s, SetSpeech, PlayerFox, "Be careful with that!");
    add_event(1, SetSwitch, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerWitch, "Sorry");
    add_event(s, SetDead, PlayerFox, "0");
    add_event(s, SetKx, PlayerFox, "1");
    add_event(0.3, SetKx, PlayerFox, "0");
    add_event(s, SetSpeech, PlayerFox, "And remember, when you divert all power to one of your abilities, you won't be able to use the others.");
    add_event(s, SetMusic, PlayerNone, "one_0");
    add_event(s, SetSpeech, PlayerWitch, "Easy. Now I'll beat him for sure.");
    add_event(s, SetSpeech, PlayerFox, "To divert power, hold CURSOR LEFT and CURSOR RIGHT for one second, at the same time");
    add_event(s, SetSpeech, PlayerWitch, "How awkward");
    add_event(s, SetSpeech, PlayerFox, "And most important of all...");
    add_event(s, SetSpeech, PlayerWitch, "Yes?");
    add_event(s, SetSpeech, PlayerFox, "If you really get a chance to defeat him...");
    add_event(s, SetSpeech, PlayerWitch, "...");
    add_event(0.1, SetKx, PlayerWitch, "1");
    add_event(0.2, SetKx, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerFox, "you need to hear it");
    add_event(s, SetSpeech, PlayerFox, "no matter how much you dread the end");
    add_event(0, SetKx, PlayerWitch, "1");
    add_event(0.5, SetKx, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerWitch, "No");
    add_event(0, SetKx, PlayerWitch, "1");
    add_event(0.5, SetKx, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerWitch, "I don't want to think about it");
    add_event(0, SetKx, PlayerWitch, "1");
    add_event(0.5, SetKx, PlayerWitch, "0");
    add_event(0.1, SetSpeech, PlayerFox, "Wait!");
    add_event(0.1, SetKx, PlayerWitch, "1");
    add_event(0.9, SetKx, PlayerWitch, "0");
    add_event(0.1, SetCutscene, PlayerNone, "0");
}
void script_beaver(void) {
    float s = 0.1;
    add_event_absolute(0, SetCutscene, PlayerNone, "1");
    add_event(0.1, SetKx, PlayerWitch, "-1");
    add_event(0.3, SetKx, PlayerWitch, "1");
    add_event(0.1, SetKx, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerBeaver, "Watch it!");
    add_event(s, SetSpeech, PlayerWitch, "Sorry!");
    add_event(s, SetSpeech, PlayerBeaver, "Your ex came through here and destroyed my house");
    add_event(s, SetSpeech, PlayerWitch, "He's not my ex");
    add_event(s, SetSpeech, PlayerBeaver, "You better pay for it");
    add_event(s, SetSpeech, PlayerWitch, "I'm sorry, but it's not my fault");
    add_event(s, SetSpeech, PlayerBeaver, "Are you sure?");
    add_event(s, SetSpeech, PlayerWitch, "Your house was just a pile of logs anyway");
    add_event(s, SetSpeech, PlayerBeaver, "Really?! Now you insult me on top of everything");
    add_event(s, SetSpeech, PlayerWitch, "No, I just meant, ...");
    add_event(s, SetSpeech, PlayerBeaver, "Just you wait! I'll warn all the forest animals about you!");
    add_event(s, SetKx, PlayerBeaver, "-1");
    add_event(0.6, SetKx, PlayerBeaver, "0");
    add_event(s, SetCutscene, PlayerNone, "0");
}
void script_racoon(void) {
    float s = 0.1;
    add_event_absolute(0, SetCutscene, PlayerNone, "1");
    add_event(0.1, SetKx, PlayerWitch, "-1");
    add_event(0.5, SetKx, PlayerWitch, "1");
    add_event(0.1, SetKx, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerRacoon, "Hello human!");
    add_event(s, SetSpeech, PlayerWitch, "Hello talking racoon!");
    add_event(s, SetSpeech, PlayerRacoon, "I hear you upset all the forest animals");
    add_event(s, SetSpeech, PlayerWitch, "No! The beaver is telling lies");
    add_event(s, SetSpeech, PlayerRacoon, "I know! She called me a thief! Can you imagine?");
    add_event(s, SetSpeech, PlayerWitch, "So you believe me?");
    add_event(s, SetSpeech, PlayerRacoon, "Depends, will you collect some rare gemstones for me?");
    add_event(s, SetSpeech, PlayerWitch, "Maybe?");
    add_event(s, SetSpeech, PlayerRacoon, "I can open doors if you do");
    add_event(s, SetSpeech, PlayerWitch, "Fine");
    add_event(s, SetSpeech, PlayerRacoon, "Remember, when in danger, always play dead");
    add_event(s, SetSpeech, PlayerWitch, "Play dead?");
    add_event(s, SetSpeech, PlayerRacoon, "Yes, press CURSOR DOWN");
    add_event(s, SetSpeech, PlayerWitch, "What?");
    add_event(s, SetSpeech, PlayerRacoon, "You won't get past that forest guardian behind me otherwise.");
    add_event(s, SetDead, PlayerWitch, "1");
    add_event(1, SetDead, PlayerWitch, "0");
    add_event(s, SetSpeech, PlayerWitch, "Thanks!");
    add_event(s, SetCutscene, PlayerNone, "0");
}
